﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using LinqToTxt;
using System.Data.Linq.Mapping;

namespace LINQtoTXT2
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        class OsobaInterfejs : Helion.ILinqToTxt
        {
            #region Pola
            private int id;
            private string imie;
            private string nazwisko;
            private int numerTelefonu;
            private int wiek;
            #endregion

            #region Wlasnosci
            public int Id
            {
                get { return id; }
                set { id = value; }
            }

            public string Imie
            {
                get { return imie; }
                set { imie = value; }
            }

            public string Nazwisko
            {
                get { return nazwisko; }
                set { nazwisko = value; }
            }

            public int NumerTelefonu
            {
                get { return numerTelefonu; }
                set { numerTelefonu = value; }
            }

            public int Wiek
            {
                get { return wiek; }
                set { wiek = value; }
            }
            #endregion

            #region Składowe ILinqToTxt
            public string MapowanieKolumn(string nazwaWlasnosci)
            {
                switch (nazwaWlasnosci)
                {
                    case "Id": return "Id";
                    case "Imie": return "Imie";
                    case "Nazwisko": return "Nazwisko";
                    case "Wiek": return "Wiek";
                    case "NumerTelefonu": return "NumerTelefonu";
                    default: return string.Empty;
                }
            }

            public void UstawWartoscPola(string nazwaKolumny, object dane)
            {
                switch (nazwaKolumny)
                {
                    case "Id": this.id = Int32.Parse(dane as string); break;
                    case "Imie": this.imie = dane as string; break;
                    case "Nazwisko": this.nazwisko = dane as string; break;
                    case "Wiek": this.wiek = Int32.Parse(dane as string); break;
                    case "NumerTelefonu": this.numerTelefonu = Int32.Parse(dane as string); break;
                    default: break;
                }
            }

            public string NazwaTabeli
            {
                get { return "ListaOsob"; }
            }
            #endregion
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //ZrodloLinqToTxt<OsobaInterfejs> zrodlo = new ZrodloLinqToTxt<OsobaInterfejs>(".");
            ZrodloLinqToTxt<OsobaInterfejs> zrodlo = new ZrodloLinqToTxt<OsobaInterfejs>("ListaOsob.txt");
            Query<OsobaInterfejs> osoby = new Query<OsobaInterfejs>(zrodlo);
            var wszystkieOsoby = from osoba in osoby
                             select osoba;                             

            var osobyPelnoletnie = from osoba in osoby
                                   where osoba.Wiek > 18
                                   orderby osoba.Imie
                                   select osoba;

            string s = "Wszystkie osoby:\n";
            foreach (OsobaInterfejs osoba in wszystkieOsoby) s += osoba.Imie + " " + osoba.Nazwisko + "\n";
            //foreach (string osoba in wszystkieOsoby) s += osoba + "\n";
            MessageBox.Show(s);

            s = "Osoby pełnoletnie:\n";
            foreach (OsobaInterfejs osoba in osobyPelnoletnie) s += osoba.Imie + " " + osoba.Nazwisko + "\n";            
            MessageBox.Show(s);

            /*
            //To nie zadziala
            var niewiasty = from osoba in osoby
                            where osoba.Imie.EndsWith("a")
                            orderby osoba.Imie
                            select osoba;

            s = "Kobiety:\n";
            foreach (OsobaInterfejs osoba in niewiasty) s += osoba.Imie + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
            */
        }

        [Table(Name = "ListaOsob")]
        class OsobaAtrybuty
        {
            private int id;
            private string imie;
            private string nazwisko;
            private int numerTelefonu;
            private int wiek;

            [Column(Name = "Id")]
            public int Id
            {
                get { return id; }
                set { id = value; }
            }

            [Column(Name = "Imie")]
            public string Imie
            {
                get { return imie; }
                set { imie = value; }
            }

            [Column(Name = "Nazwisko")]
            public string Nazwisko
            {
                get { return nazwisko; }
                set { nazwisko = value; }
            }

            [Column(Name = "NumerTelefonu")]
            public int NumerTelefonu
            {
                get { return numerTelefonu; }
                set { numerTelefonu = value; }
            }

            [Column(Name = "Wiek")]
            public int Wiek
            {
                get { return wiek; }
                set { wiek = value; }
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //ZrodloLinqToTxt<OsobaAtrybuty> zrodlo = new ZrodloLinqToTxt<OsobaAtrybuty>(".");
            ZrodloLinqToTxt<OsobaAtrybuty> zrodlo = new ZrodloLinqToTxt<OsobaAtrybuty>("ListaOsob.txt");
            Query<OsobaAtrybuty> osoby = new Query<OsobaAtrybuty>(zrodlo);
            var wszystkieOsoby = from osoba in osoby
                                 orderby osoba.Wiek
                                 select osoba;

            var osobyPelnoletnie = from osoba in osoby
                                   where osoba.Wiek > 18
                                   select osoba;            

            string s = "Wszystkie osoby:\n";
            foreach (OsobaAtrybuty osoba in wszystkieOsoby) s += osoba.Imie + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";            
            MessageBox.Show(s);

            s = "Osoby pełnoletnie:\n";
            foreach (OsobaAtrybuty osoba in osobyPelnoletnie) s += osoba.Imie + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            /*
            //To nie zadziala
            var niewiasty = from osoba in osoby
                            where osoba.Imie.EndsWith("a")
                            orderby osoba.Imie
                            select osoba;

            s = "Kobiety:\n";
            foreach (OsobaAtrybuty osoba in niewiasty) s += osoba.Imie + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
            */
        }

        private void button3_Click(object sender, EventArgs e)
        {
            ZrodloLinqToTxt<List<string>> zrodlo = new ZrodloLinqToTxt<List<string>>("ListaOsob.txt");
            Query<List<string>> osoby = new Query<List<string>>(zrodlo);
            var wszystkieOsoby = from osoba in osoby
                                 orderby osoba[4]
                                 select osoba;

            /*
            var osobyPelnoletnie = from osoba in osoby
                                   where Int32.Parse(osoba[4]) > 18
                                   select osoba;
            */

            string s = "Wszystkie osoby:\n";
            foreach (List<string> osoba in wszystkieOsoby) s += osoba[1] + " " + osoba[2] + " (" + osoba[4] + ")\n";            
            MessageBox.Show(s);

            /*
            s = "Osoby pełnoletnie:\n";
            foreach (List<string> osoba in osobyPelnoletnie) s += osoba[1] + " " + osoba[2] + " (" + osoba[4] + ")\n";
            MessageBox.Show(s);
            */

            /*
            //To nie zadziala
            var niewiasty = from osoba in osoby
                            where osoba.Imie.EndsWith("a")
                            orderby osoba.Imie
                            select osoba;

            s = "Kobiety:\n";
            foreach (Osoba2 osoba in niewiasty) s += osoba.Imie + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
            */
        }
    }
}
